package gov.va.med.mhv.bluebutton.service.impl;

import gov.va.med.mhv.bluebutton.HealthSummaryBusinessService;
import gov.va.med.mhv.bluebutton.healthsummary.util.PdfXHTMLWrapper;
import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.transfer.Session;
import gov.va.med.mhv.osccd.client.BlueButtonRepository;
import gov.va.med.mhv.osccd.client.C32Document;
import gov.va.med.mhv.osccd.client.DocStatus;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;
import gov.va.med.mhv.usermgmt.service.PatientWebService;
import gov.va.med.mhv.usermgmt.util.activity.ActivityHelper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.ws.rs.core.Response;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * Service implementation class for the HealthSummaryBusiness service
 * @see gov.va.med.mhv.bluebutton.HealthSummaryBusinessService
 */

@Component
public class HealthSummaryBusinessServiceImpl implements HealthSummaryBusinessService {
	private static Logger logger = LogManager.getLogger(HealthSummaryBusinessServiceImpl.class);
	
	@Resource
	private BlueButtonRepository factory;
	
	@Resource(name = "activityProxy")
	private AccountActivityCreatorService acctActCreatorService; 
//	
//	@Resource
//	private HealthSummaryBusinessService healthSummaryService;
	
	@Resource
	private AccountActivityCreatorService activityProxy;

	@Resource
	private PatientWebService patientProxy;
	
	@Autowired
	PdfXHTMLWrapper hsPdfWrapper;
	
	@Autowired
	@Qualifier("ccdaFile")
	org.springframework.core.io.Resource  ccdaFile;
	
	@Autowired
	@Qualifier("ccdFile")
	org.springframework.core.io.Resource  ccdFile;
	
//	@Autowired
//	TransformerFactory tfactory;
	
	
	private static Map<String, Templates> CACHE = new Hashtable<String, Templates>();
    // map of Templates objects
	private String xslFileName;
	    // the filename of stylesheet and key to map
	private Transformer transformer; 
	
	public List<DocStatus> getStatus(String patientId, String lastName, String format) throws MHVException {
		return factory.getRepositoryWSPort().getStatus(patientId, lastName, format);
	}
	
	public Response getDocument(String requestDate, String fileFormat, String ccdType) throws MHVException {
		if(logger.isDebugEnabled()) {
			logger.debug("*************** HealthSummaryServiceImpl Initiated...  *****************");	
		}
		System.out.println("Launching get Document in HealthSummaryBusinessService");
		Session session =  CacheHandler.getInstance().getSession();
		Long userProfileId = session.getUserId();
		PatientDTO patDTO = patientProxy.getPatientByUserProfileId(userProfileId);
		UserProfileDTO userProfile = patDTO.getUserProfile();
		
		Calendar requestDateCal = Calendar.getInstance();
    	if(requestDate!=null){
			DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH':'mm");
			Date date = null;
			try {
				date = formatter.parse(requestDate);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			requestDateCal.setTime(date);
		}
		
		SimpleDateFormat formatter = new SimpleDateFormat("'_'yyyyMMdd'_'HHmm");
		Timestamp t = null;
		t = new Timestamp(requestDateCal.getTime().getTime());
		StringBuffer hhFileName = new StringBuffer();
		hhFileName.append("mhv_VA_CCD_");
		hhFileName.append(userProfile.getName().getLastName());
		hhFileName.append(formatter.format(t));
		byte[] fileBytes =null;
		String userFullName = userProfile.getName().getFirstName() + " " + userProfile.getName().getLastName();
		
		fileBytes = getDownloadPayload(requestDate, patDTO.getIcn(), userProfileId, fileFormat, ccdType, hhFileName, userFullName);
	
		switch(fileFormat) {
		case "PDF": 
				
			hhFileName.append(".pdf");	
			return Response.ok().entity(fileBytes).header("Expires","-1").header("Cache-Control","no-cache").header("Content-Type","application/pdf").header
					("Content-Length", fileBytes.length).header("Content-Disposition","attachment; filename="+hhFileName).build();
			
		case "PREVIEW": 
			
			hhFileName.append(".pdf");	
			return Response.ok().entity(fileBytes).header("Expires","-1").header("Cache-Control","no-cache").header("Content-Type","application/pdf").header
					("Content-Length", fileBytes.length).header("Content-Disposition","inline; filename="+hhFileName).build();
		case "XML": 
	
			hhFileName.append(".xml");
			return Response.ok().entity(fileBytes).header("Expires","-1").header("Cache-Control","no-cache").header("Content-Type","text/xml").header
					("Content-Length", fileBytes.length).header("Content-Disposition","attachment; filename="+hhFileName).build();
	
		default:

		}

		return null;
	}
	

    public byte[] getDownloadPayload(String requestDate, String icn, Long userProfileId, String fileFormat, String ccdType, StringBuffer hsFileName, String userFullName){

 
    	C32Document ccda = null;
    	Calendar requestDateCal = Calendar.getInstance();
    	byte[] fileBytes =null;
    	
		
    	if(requestDate!=null){
			DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH':'mm");
			Date date = null;
			try {
				date = formatter.parse(requestDate);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			requestDateCal.setTime(date);
		}

      //request the document
    	try {
			//Call the service to retrieve a C-CDA
			DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH':'mm");
			Date date = null;
			XMLGregorianCalendar calendaredRequestDate = DatatypeFactory.newInstance().newXMLGregorianCalendar();
			try {
				date = formatter.parse(requestDate);
				GregorianCalendar c = new GregorianCalendar();
				c.setTime(date);
				calendaredRequestDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
			} catch (ParseException e) {
				//log.error(e.getStackTrace());
			}
			ccda = factory.getRepositoryWSPort().getDocument(calendaredRequestDate, icn);
		
			
		} catch (DatatypeConfigurationException e) {
    		try {
				activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, false, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.DOWNLOAD_MY_VA_HEALTH_SUMMARY, ""));
			} catch (MHVException e1) {
				logger.error(e1);
			}
		}

		if(ccda != null) {
			fileBytes = decode(ccda.getDocument());
		}

		try {
			if(fileFormat.equalsIgnoreCase("XML")){

				// Audit Download Events starts here
				activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, true, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.DOWNLOAD_MY_VA_HEALTH_SUMMARY, ""));
			}else{
				
				xslFileName = "";
				
				if(ccdType.equals("CCDA"))
					xslFileName = "xsl/cda.xsl";
				else
					xslFileName = "xsl/CCD.xsl";
				
				Templates templates = (Templates)CACHE.get(xslFileName);
		        if (templates == null)
		        {
		            TransformerFactory tfactory =
		                       TransformerFactory.newInstance();
		            
		            ClassLoader cl = this.getClass().getClassLoader();
		            String systemID = xslFileName;
		            InputStream in = cl.getResourceAsStream(systemID);
		            URL url = cl.getResource(systemID);
		            Source xslSource = new StreamSource(in);
		            xslSource.setSystemId(url.toExternalForm());

		            templates = tfactory.newTemplates
		                        (xslSource);

		            CACHE.put(xslFileName, templates);
		        }
		        transformer  = templates.newTransformer();
		        
		       
				
				ByteArrayInputStream stream = new ByteArrayInputStream(fileBytes);
				Source source = new StreamSource((InputStream) stream);

				ByteArrayOutputStream os = new ByteArrayOutputStream();
				//Result result = new StreamResult(os);
				try{
					transformer.transform(source, new StreamResult(os));
				}catch(Exception e){
					e.printStackTrace();
				}
				
				
				PdfXHTMLWrapper p = new PdfXHTMLWrapper();
				fileBytes = p.makePdfFromXhtml(userFullName, os.toString());

				// Audit Download Events starts here
				if (!fileFormat.equalsIgnoreCase("PREVIEW")) {
					activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, true, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.DOWNLOAD_MY_VA_HEALTH_SUMMARY_PDF, ""));
				}
			}
		} catch (Exception e) {
			try {
				activityProxy.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileId, false, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.DOWNLOAD_MY_VA_HEALTH_SUMMARY, ""));
			} catch (MHVException e1) {
				logger.error(e1);
			}
		}

        return fileBytes;
    }
    
    public static byte[] decode(String encoded) {
		byte[] decoded = org.apache.commons.codec.binary.Base64.decodeBase64(encoded.getBytes());
		return decoded;
	}
    	
}
